<!-- INDEX VERSION 1.0 19/11/2020 12:00 AM -->
<?php require(__DIR__ . '/settings.php') ?>

<!DOCTYPE html>
<html dir="ltr">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1" name="viewport">
    <meta data-text-id="140149">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,400;0,700;0,900;1,400;1,700&display=swap" rel="stylesheet">
    <title>Deep Inhale</title>
    <link href="css/normalize.css" rel="stylesheet" type="text/css">
    <link href="css/slick-theme.css" rel="stylesheet" type="text/css">
    <link href="css/slick.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">

    <!-- Integration code block -->
    <?= injectCodeBlock() ?>
    <!-- Integration code block END-->

    <script src="js/slick.min.js" type="text/javascript"></script>
</head>

<body>
    <?= addBodyTopCode(); ?>
    <div class="wrapper">
        <div class="top-block">
            <div class="container clearfix">
                <div class="top-block__left">
                    <!-- <img src="img/logo-top_1.png" alt="pic" class="logo-left web"> --><span class="logo-left web text-logo"> Deep </span><!-- <img src="img/logo-mob.png" alt="pic" class="logo-mob mob"> --><span class="logo-mob mob text-logo"> Deep Inhale </span>
                    <div class="first-text"> Dišite slobodno </div>
                    <div class="second-text"> Zaštita pluća od infekcija i toksina </div>
                </div><img alt="pic" class="lungs-image" src="img/lungs.png"><img alt="pic" class="product web" src="img/product.png"><img alt="pic" class="product mob" src="img/product-mob.png">
                <div class="top-block__right">
                    <!-- <img src="img/logo-top_2.png" alt="pic" class="logo-right web"> --><span class="logo-right web text-logo"> Inhale </span>
                    <div class="list">
                        <div class="item"> Prevencija respiratornih bolesti </div>
                        <div class="item"> Zaštita od djelovanja aktivnog i pasivnog pušenja </div>
                        <div class="item"> Podrška normalnoj funkciji pluća </div>
                    </div>
                </div>
                <div class="clearfix"></div><button class="button scroll"> naruči odmah </button>
            </div>
        </div>
        <div class="second-block">
            <div class="container v1">
                <div class="second-block__title"> Zašto je respiratornom sistemu <span> potrebna pomoć? </span></div>
                <div class="second-block__text"> 99,5% građana BiH živi na mjestima gdje je nivo zagađenosti zraka kritičan. </div>
                <div class="second-block__text-v2"> Ovo ima dva nepovratna faktora: </div>
                <div class="second-block__list web">
                    <div class="line first">
                        <div class="item">
                            <div class="top">
                                <div class="top-text"> 2 </div>
                                <div class="bottom-text"> Svake minute dvoje ljudi </div>
                            </div>
                            <div class="bottom"><span> umre od bolesti uzrokovanih zagađenjem zraka </span> (infekcije donjih disajnih puteva, upala pluća, srčani udar, moždani udar, dijabetes i rak pluća) </div>
                        </div>
                        <div class="item">
                            <div class="top">
                                <div class="top-text"> 12 godina </div>
                                <div class="bottom-text"> Životni vijek svakog građanina BiH se smanjuje </div>
                            </div>
                            <div class="bottom"><span> za 5-12 godina </span> (u poređenju sa životnim vijekom u drugim državama) </div>
                        </div>
                        <div class="item">
                            <div class="top">
                                <div class="top-text"> 16% </div>
                                <div class="bottom-text"> Broj oboljelih </div>
                            </div>
                            <div class="bottom"><span> od raka respiratornog sistema povećao se </span> za 16% </div>
                        </div>
                    </div>
                    <div class="line second">
                        <div class="item">
                            <div class="top">
                                <div class="top-text"> 23% </div>
                                <div class="bottom-text"> Broj oboljelih od astme </div>
                            </div>
                            <div class="bottom"><span> povećao se za 23% </span></div>
                        </div>
                        <div class="item">
                            <div class="top">
                                <div class="top-text"> 31% </div>
                                <div class="bottom-text"> Rasprostranjenost respiratornih infekcija </div>
                            </div>
                            <div class="bottom"><span> povećala se </span> za 31% </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="second-block__list second-block__list--mob mob slider">
                    <div class="item">
                        <div class="top">
                            <div class="top-text"> 2 </div>
                            <div class="bottom-text"> Svake minute dvoje ljudi </div>
                        </div>
                        <div class="bottom"><span> umre od bolesti uzrokovanih zagađenjem zraka </span> (infekcije donjih disajnih puteva, upala pluća, srčani udar, moždani udar, dijabetes i rak pluća) </div>
                    </div>
                    <div class="item">
                        <div class="top">
                            <div class="top-text"> 12 godina </div>
                            <div class="bottom-text"> Životni vijek svakog građanina BiH se smanjuje </div>
                        </div>
                        <div class="bottom"><span> za 5-12 godina </span> (u poređenju sa životnim vijekom u drugim državama) </div>
                    </div>
                    <div class="item">
                        <div class="top">
                            <div class="top-text"> 16% </div>
                            <div class="bottom-text"> Broj oboljelih </div>
                        </div>
                        <div class="bottom"><span> od raka respiratornog sistema povećao se </span> za 16% </div>
                    </div>
                    <div class="item">
                        <div class="top">
                            <div class="top-text"> 23% </div>
                            <div class="bottom-text"> Broj oboljelih od astme </div>
                        </div>
                        <div class="bottom"><span> povećao se za 23% </span></div>
                    </div>
                    <div class="item">
                        <div class="top">
                            <div class="top-text"> 31% </div>
                            <div class="bottom-text"> Rasprostranjenost respiratornih infekcija </div>
                        </div>
                        <div class="bottom"><span> povećala se </span> za 31% </div>
                    </div>
                </div>
                <div class="slider-dots_2"></div>
            </div>
        </div>
        <div class="third-block">
            <div class="container">
                <div class="third-block__left">
                    <!-- <img src="img/logo-top_1_v2.png" alt="pic" class="logo web"> --><span class="logo web text-logo text-logo--small"> Deep </span><!-- <img src="img/logo-mob.png" alt="pic" class="logo-mob mob"> --><span class="logo-mob mob text-logo"> Deep Inhale </span>
                    <div class="text"> Deep Inhale može pomoći kod prevencije toksičnog uticaja zagađenja zraka. </div>
                </div><img alt="pic" class="product" src="img/product.png">
                <div class="third-block__right">
                    <!-- <img src="img/logo-top_2_v2.png" alt="pic" class="logo"> --><span class="logo web text-logo text-logo--small"> Inhale </span>
                    <div class="text"><b> Biljni čaj štiti respiratorni sistem </b> , povećava otpornost organizma na respiratorne infekcije i čisti pluća od toksina i šlajma. </div>
                </div>
            </div>
        </div>
        <div class="fourth-block">
            <div class="container clearfix"><img alt="pic" class="leaf_1 rellax" src="img/paralax_2.png"><img alt="pic" class="leaf_2 rellax" src="img/paralax_1.png">
                <div class="fourth-block__left">
                    <div class="logo-block">
                        <div class="logo-block">
                            <!-- <img src="img/logo-top_1.png" alt="pic" class="web"> --><span class="web text-logo"> Deep <br> Inhale </span><!-- <img src="img/logo-top_2.png" alt="pic" class="web"> -->
                            <!-- <img src="img/logo-mobile.png" alt="pic" class="mob"> --><span class="mob text-logo"> Deep Inhale </span></div>
                        <div class="big-text"> prirodni proizvod za održavanje zdravlja respiratornog sistema </div>
                        <div class="text"><b> Zagađenost zraka, štetne navike, nezdrava ishrana i GMO proizvodi slabe vaš imunitet. </b> To dovodi do čestih prehlada, respiratornih bolesti i komplikacija. U takvim uslovima, respiratornom sistemu je potrebna pouzdana zaštita. Deep Inhale je čaj usmjerenog djelovanja koji <b> se bori protiv svih tih problema </b> . </div>
                    </div>
                </div><img alt="pic" class="flowers" src="img/flowers.png">
                <div class="fourth-block__right">
                    <div class="list">
                        <div class="item">
                            <!-- <img src="img/list_1.png" alt="pic"> -->
                            <div class="text"><span> Razrjeđuje šlajm </span> Olakšava njegovo izbacivanje </div>
                        </div>
                        <div class="item">
                            <!-- <img src="img/list_2.png" alt="pic"> -->
                            <div class="text"><span> Povećava plućnu ventilaciju i </span> poboljšava funkciju pluća. </div>
                        </div>
                        <div class="item">
                            <!-- <img src="img/list_3.png" alt="pic"> -->
                            <div class="text"><span> Smanjuje toksični efekat </span> štetnih materija i nikotina </div>
                        </div>
                        <div class="item">
                            <!-- <img src="img/list_4.png" alt="pic"> -->
                            <div class="text"><span> Smanjuje učestalost pojave respiratornih bolesti </span> uključujući i upalu pluća. </div>
                        </div>
                        <div class="item">
                            <!-- <img src="img/list_5.png" alt="pic"> -->
                            <div class="text"><span> Stimulira prirodnu regeneraciju </span> i obnovu ćelija </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="fifth-block">
                <div class="container"><img alt="pic" class="leaf_3 rellax" src="img/paralax_3.png"><img alt="pic" class="leaf_4 rellax" src="img/paralax_4.png">
                    <div class="fifth-block__title"> Prirodna njega za zdravlje pluća </div>
                    <div class="composition-block">
                        <div class="item top"><img alt="pic" class="mob" src="img/component_1.jpg"><span> List podbjela </span>
                            <div class="text"> Dubinski čisti respiratorni sistem od sluzi i šlajma, obavija alveole i štiti ih od povreda, olakšava disanje, sprječava ponovno nakupljanje sluzi u plućima. </div><img alt="pic" class="web" src="img/component_1.jpg">
                        </div>
                        <div class="inner-wrap clearfix">
                            <div class="left-side">
                                <div class="item clearfix"><img alt="pic" src="img/component_10.jpg">
                                    <div class="left"><span> Cvijet crnog sljeza </span>
                                        <div class="text"> Povećava imunitet, omogućuje razjređivanje i izbacivanje šlajma, ima protuupalno djelovanje, efikasan je kod suhog kašlja i pušačkog kašlja. </div>
                                    </div>
                                </div>
                                <div class="item clearfix"><img alt="pic" src="img/component_9.jpg">
                                    <div class="left"><span> Korijen bijelog sljeza </span>
                                        <div class="text"> Pomaže kod iskašljavanja i ima protuupalno djelovanje, štiti pluća, bronhije i traheje od štetnog djelovanja, povećava zasićenost krvi kisikom. </div>
                                    </div>
                                </div>
                            </div><img alt="pic" class="product" src="img/product2.png">
                            <div class="right-side">
                                <div class="item clearfix"><img alt="pic" src="img/component_2.jpg">
                                    <div class="right"><span> Korijen sladića </span>
                                        <div class="text"> Omogućuje lako izbacivanje šlajma, uklanja i sprječava upale i grčeve, ojačava prirodnu regeneraciju ćelija, obnavlja elastičnst zidova alveola. </div>
                                    </div>
                                </div>
                                <div class="item clearfix"><img alt="pic" src="img/component_3.jpg">
                                    <div class="right"><span> Plod komorača </span>
                                        <div class="text"> Protuupalno sredstvo koje pomaže kod iskašljavanja, sprječava razvoj hroničnih bolesti disajnih organa. </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="sixth-block">
                <div class="container clearfix">
                    <div class="left"><img alt="pic" class="doc" src="img/doc.png">
                        <div class="bottom-text web clearfix">
                            <div class="name"> Irma Buljubašić </div>
                            <p> ljekar porodične medicine, ima 8 godina iskustva </p>
                        </div>
                    </div>
                    <div class="right">
                        <div class="logo-block web">
                            <!-- <img src="img/logo-top_1.png" alt="pic"> -->
                            <!-- <img src="img/logo-top_2.png" alt="pic"> --><span class="text-logo"> Deep Inhale </span></div><!-- <img src="img/logo-mob.png" alt="pic" class="mob logo-mob"> --><span class="text-logo mob logo-mob"> Deep Inhale </span>
                        <div class="big-text"> Prevencija respiratornih bolesti </div>
                        <div class="bottom-text mob">
                            <div class="name"> Irma Buljubašić </div>
                            <p> ljekar porodične medicine, ima 8 godina iskustva </p>
                        </div>
                        <div class="text-little"> Deep Inhale je novi kompleks dizajniran radi zaštite pluća od infekcija, toksina i alergena. </div>
                        <div class="list-inner">
                            <div class="top-text"> Čaj je testiran na Europskom istraživačkom univerzitetu*: </div>
                            <div class="list">
                                <div class="line">
                                    <div class="item clearfix">
                                        <div class="text"> Povećava zasićenost krvi kisikom </div><span> 94% </span>
                                    </div>
                                    <div class="progress-wrap">
                                        <div class="inner-wrap">
                                            <div class="progress-bar"> 1% </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="line">
                                    <div class="item clearfix">
                                        <div class="text"> Smanjuje učestalost pojave respiratornih infekcija </div><span> 91% </span>
                                    </div>
                                    <div class="progress-wrap">
                                        <div class="inner-wrap">
                                            <div class="progress-bar"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="line">
                                    <div class="item clearfix">
                                        <div class="text"> Povećava kapacitet pluća </div><span> 83% </span>
                                    </div>
                                    <div class="progress-wrap">
                                        <div class="inner-wrap">
                                            <div class="progress-bar" id="myBar"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="line">
                                    <div class="item clearfix">
                                        <div class="text"> Povećava plućnu ventilaciju </div><span> 78% </span>
                                    </div>
                                    <div class="progress-wrap">
                                        <div class="inner-wrap">
                                            <div class="progress-bar"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="bottom-text">
                                <p> *258 ljudi učestvovalo je u ispitivanju, tretman je trajao 1 mjesec </p>
                                <p> **Na osnovu rezultata laboratorijskih i kliničkih ispitivanja </p>
                            </div>
                        </div>
                        <div class="footnote"> Rezultati ispitivanja pokazuju da Deep Inhale pouzdano štiti respiratorni sistem od toksina i infekcija. </div>
                    </div>
                    <div class="clearfix"></div><button class="button scroll"> Uvjeri se u djelotvornost čaja <br><span> Deep Inhale </span></button>
                </div>
            </div>
            <div class="reviews-block">
                <div class="container clearfix">
                    <div class="left-side">
                        <div class="big-text"> Oni su već otkrili djelotvornost ovog proizvoda </div>
                        <div class="logo-block">
                            <!-- <img src="img/logo-top_1.png" alt="pic"> -->
                            <!-- <img src="img/logo-top_2.png" alt="pic"> --><span class="text-logo"> Deep Inhale </span></div>
                        <div class="text"> Pridruži im se </div>
                        <div class="comment">
                            <div class="comment__top"><img alt="pic" class="avatar" src="img/ava_3.jpg">
                                <div class="right">
                                    <div class="name"> Mirsada Hasić </div><img alt="pic" class="stars" src="img/stars.png">
                                </div>
                            </div>
                            <div class="comment-bottom"> Svi u mojoj porodici puše. Već nekoliko godina patim od pušačkog kašlja. Probala sam svakakve tablete i sirupe, ali samo su privremeno olakšavali simptome, a onda bi se simptomi vraćali kad se liječenje završi. Prošla sam tretman uz Deep Inhale prije nekoliko mjeseci. Kašalj se nije vratio i osjećam se puno bolje! </div>
                        </div>
                        <div class="comment">
                            <div class="comment__top"><img alt="pic" class="avatar" src="img/ava_5.jpg">
                                <div class="right">
                                    <div class="name"> Samira Delibašić </div><img alt="pic" class="stars" src="img/stars.png">
                                </div>
                            </div>
                            <div class="comment-bottom"> Imam astmu nekoliko godina. Inhalatori mi pomažu, ali efekat ne traje dovoljno dugo. Sestra mi je preporučila da probam Deep Inhale. Nisam se uspjela riješiti svih simptoma, naravno, ali moje stanje se značajno popravilo tokom dvije sedmice koliko sam ga koristila. Skoro da i nemam napade astme. Ovo je definitivno najbolji proizvod koji sam ikad probala za poboljšanje zdravlja. </div>
                        </div>
                    </div>
                    <div class="right-side slider2">
                        <div class="comment mob">
                            <div class="comment__top"><img alt="pic" class="avatar" src="img/ava_3.jpg">
                                <div class="right">
                                    <div class="name"> Mirsada Hasić </div><img alt="pic" class="stars" src="img/stars.png">
                                </div>
                            </div>
                            <div class="comment-bottom"> Svi u mojoj porodici puše. Već nekoliko godina patim od pušačkog kašlja. Probala sam svakakve tablete i sirupe, ali samo su privremeno olakšavali simptome, a onda bi se simptomi vraćali kad se liječenje završi. Prošla sam tretman uz Deep Inhale prije nekoliko mjeseci. Kašalj se nije vratio i osjećam se puno bolje! </div>
                        </div>
                        <div class="comment mob">
                            <div class="comment__top"><img alt="pic" class="avatar" src="img/ava_5.jpg">
                                <div class="right">
                                    <div class="name"> Samira Delibašić </div><img alt="pic" class="stars" src="img/stars.png">
                                </div>
                            </div>
                            <div class="comment-bottom"> Imam astmu nekoliko godina. Inhalatori mi pomažu, ali efekat ne traje dovoljno dugo. Sestra mi je preporučila da probam Deep Inhale. Nisam se uspjela riješiti svih simptoma, naravno, ali moje stanje se značajno popravilo tokom dvije sedmice koliko sam ga koristila. Skoro da i nemam napade astme. Ovo je definitivno najbolji proizvod koji sam ikad probala za poboljšanje zdravlja. </div>
                        </div>
                        <div class="comment">
                            <div class="comment__top"><img alt="pic" class="avatar" src="img/ava_2.jpg">
                                <div class="right">
                                    <div class="name"> Adem Nezirović </div><img alt="pic" class="stars" src="img/stars.png">
                                </div>
                            </div>
                            <div class="comment-bottom"> Ja živim u Tuzli i svaki dan radim na ulici, a zrak je užasno zagađen. Ponekad prosto nije moguće raditi bez maske. Počeo sam kašljati i dijagnosticirali su mi hronični bronhitis. Nisam htio koristiti antibiotike i odabrao sam Deep Inhale - prirodni biljni čaj. Poboljšanja sam primijetio petog dana tretmana jer sam počeo manje kašljati. Za 1,5 sedmicu sam zaboravio na sve simptome. Ovo je odličan proizvod i ponovo planiram proći jedan tretman. </div>
                        </div>
                        <div class="comment">
                            <div class="comment__top"><img alt="pic" class="avatar" src="img/ava_1.jpg">
                                <div class="right">
                                    <div class="name"> Ibro Mujić </div><img alt="pic" class="stars" src="img/stars.png">
                                </div>
                            </div>
                            <div class="comment-bottom"> Prije godinu dana sam imao upalu pluća. Stanje se pogoršalao 1,5 -2 mjeseca nakon liječenja. Komšija, dugogodišnji pušač, mi je savjetovao Deep Inhale. Odlučio sam probati i svidjelo mi se. Nema znakova hronične upale pluća već 3 mjeseca. Nema kašlja ni otežanog disanja. Posebno zahvaljujem komšiji za ovu preporuku. </div>
                        </div>
                        <div class="comment">
                            <div class="comment__top"><img alt="pic" class="avatar" src="img/ava_4.jpg">
                                <div class="right">
                                    <div class="name"> Hanifa Tahirović </div><img alt="pic" class="stars" src="img/stars.png">
                                </div>
                            </div>
                            <div class="comment-bottom"> Konačno sam pronašla pravi proizvod za zaštitu pluća od zagađenja. Moj muž uvijek puši u kući i zato imam suhi kašalj, a i on mnogo kašlje. Vidjela sam reklamu za Deep Inhael i naručila radi prevencije. Koristimo ga 1,5 sedmicu i već se osjećamo mnogo bolje, kašlja skoro da i nema. E to ja zovem dobrim proizvodom! </div>
                        </div>
                    </div>
                    <div class="slider-dots"></div>
                </div>
            </div>
            <div class="how_order-block">
                <div class="container">
                    <div class="logo-block">
                        <!-- <img src="img/logo-top_1_v2.png" alt="pic" class="web"> -->
                        <!-- <img src="img/logo-top_2_v2.png" alt="pic" class="web"> --><span class="web text-logo"> Deep Inhale </span><!-- <img src="img/logo-mobile.png" alt="pic" class="mob"> --><span class="mob text-logo"> Deep Inhale </span></div>
                    <div class="text"> Kako naručiti </div>
                    <div class="inner-wrap">
                        <div class="item">
                            <div class="image-wrap"><img alt="pic" class="how_order-block--image" src="img/tablet.png"></div>
                            <p><span> Ispunite narudžbenicu, </span> navedite svoje kontakt podatke </p>
                        </div>
                        <div class="item">
                            <div class="image-wrap"><img alt="pic" class="how_order-block--image" src="img/cup.png"></div>
                            <p><span> Pričekajte poziv operatera </span> radi detalja. </p>
                        </div>
                        <div class="item">
                            <div class="image-wrap"><img alt="pic" class="how_order-block--image" src="img/box.png"></div>
                            <p><span> Preuzmite pošiljku </span> na vama odgovarajući način i platite pouzećem. </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ninth-block">
                <div class="container clearfix"><img alt="pic" class="leaf_2 rellax" src="img/paralax_2.png">
                    <div class="left">
                        <div class="text"> Kako naručiti originalni proizvod </div>
                        <div class="logo-block">
                            <!-- <img src="img/logo-top_1.png" alt="pic"> -->
                            <!-- <img src="img/logo-top_2.png" alt="pic"> --><span class="text-logo"> Deep <br> Inhale </span></div>
                        <div class="mob-block mob"><img alt="pic" class="lungs_2" src="img/lungs_2.png"><img alt="pic" class="product" src="img/product.png"></div>
                        <p> Pošto potražnja za čajem Deep Inhale raste, količina falsifikata dostiže rekordan nivo. <span> Originalni čaj Deep Inhale možete naručiti samo na našem sajtu </span> . Mi smo službeni predstavnici proizvođača i našim kupcima nudimo povoljne uslove za kupovinu čaja Deep Inhale. </p>
                    </div>
                    <div class="right"><img alt="pic" class="product web rellax web" src="img/product.png"><img alt="pic" class="lungs_2 web" src="img/lungs_2.png"></div><img alt="pic" class="leaf_1 rellax" src="img/paralax_1.png">
                </div>
            </div>
            <div class="form-block">
                <div class="container clearfix"><img alt="pic" class="product" src="img/product3.png">
                    <div class="top-block__left">
                        <!-- <img src="img/logo-mob.png" alt="pic" class="mob logo-mob"> --><span class="logo-mob mob text-logo"> Deep Inhale </span><!-- <img src="img/logo-top_1.png" alt="pic" class="logo-left web"> --><span class="logo-left web text-logo"> Deep </span>
                        <div class="first-text"> Dišite slobodno </div>
                        <div class="second-text"> Zaštita pluća od infekcija i toksina </div>
                        <div class="list">
                            <div class="item"> Prevencija respiratornih bolesti </div>
                            <div class="item"> Zaštita od djelovanja aktivnog i pasivnog pušenja </div>
                            <div class="item"> Podrška normalnoj funkciji pluća </div>
                        </div>
                    </div>
                    <div class="right clearfix">
                        <!-- <img src="img/logo-top_2.png" alt="pic" class="logo-right web"> --><span class="logo-right web text-logo"> Inhale </span>
                        <div class="form-wrap">
                            <div class="form-wrap__title"> ispuni narudžbenicu </div>
                            <form action="<?= $actionEndPoint ?>" method="post">
                                <?= generateHiddenFields() ?>
                                <div class="select-wrap"><select class="field sel" id="country_code_selector" name="country_code">
                                        <?= getCountryInOption() ?>
                                    </select></div><input class="field" name="name" placeholder="Ime" type="text">
                                <input class="only_number field" name="phone" placeholder="Broj telefona" type="tel"><br><br>
                                <div class="select-wrap"><select class="change-package-selector2 field sel" id="change" name="quantity">
                                        <?= getPaketiInOption() ?>
                                    </select></div><button class="button js_submit button__text"> naruči odmah </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="js/slick-settings.js" type="text/javascript"></script>
        <script src="js/rellax.js" type="text/javascript"></script>
        <script src="js/main.js" type="text/javascript"></script>
    </div>
    <script>
        $(document).ready(function() {
            try {
                moment.locale("");
                $('.day-before').text(moment().subtract(1, 'day').format('D.MM.YYYY'));
                $('.day-after').text(moment().add(1, 'day').format('D.MM.YYYY'));
            } catch (e) {
                console.log('moment problems!');
            }
        });
    </script>

    <?= generateFooter(); ?>

    <?= addBodyBottomCode(); ?>

</body>

</html>